﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data;
using System.Configuration;
using System.IO;
using System.Drawing;


using Matris;
using IPBL;


public static class Plotter
{
    /// <summary>
    /// نمودار برای هر سه رنگ آبی و قرمز و سبز
    /// </summary>
    /// <param name="filename"></param>
    /// <returns></returns>
    public static Bitmap ColorsCount(ref Bitmap image)
    {
        //برا وقتی اینجا تعریف میشه که نمودار درصدی هستش
        Bitmap newimage = new Bitmap(300, 400);

        int[, ,] imagematris = Matris.Load.Matris3DFromeBMP(image);

        #region count
        int width = image.Width, height = image.Height;
        double[] rCount = new double[256];
        double[] bCount = new double[256];
        double[] gCount = new double[256];
        double rMax = 0, bMax = 0, gMax = 0;
        int rmaxIndex = 0, gmaxIndex = 0, bmaxIndex = 0;
        for (int i = 0; i < width; i++)
        {
            for (int j = 0; j < height; j++)
            {
                int r_ = imagematris[i, j, 0];
                double r = rCount[r_]++;
                if (r > rMax)
                {
                    rMax = r; //if (r_ != 0 && r_ != 255)
                    rmaxIndex = r_;
                }
                int g_ = imagematris[i, j, 1];
                double g = gCount[g_]++;
                if (g > gMax)
                {
                    gMax = g; //if (g_ != 0 && g_ != 255)
                    gmaxIndex = g_;
                }
                int b_ = imagematris[i, j, 2];
                double b = bCount[b_]++;
                if (b > bMax)
                {
                    bMax = b; //if (b_ != 0 && b_ != 255)
                    bmaxIndex = b_;
                }
            }
        }

        // برای وقتی که میخوای درصد نشون بدی
        for (int i = 0; i < 256; i++)
        {
            rCount[i] = rCount[i] / rMax * 100;
            gCount[i] = gCount[i] / gMax * 100;
            bCount[i] = bCount[i] / bMax * 100;
        }
        #endregion

        #region rulers
        int StartposX = 20, StartposY = 120, EndposX = 276, EndposY = 20;
        //ofoghi
        for (int i = StartposX; i < EndposX; i++)
        {
            newimage.SetPixel(i, StartposY, Color.White);
            newimage.SetPixel(i, StartposY + 120, Color.White);
            newimage.SetPixel(i, StartposY + 240, Color.White);

            if ((i - StartposX) % 10 == 0)
            {
                newimage.SetPixel(i, StartposY + 1, Color.White);
                newimage.SetPixel(i, StartposY + 121, Color.White);
                newimage.SetPixel(i, StartposY + 241, Color.White);
            }
            if ((i - StartposX) % 50 == 0)
            {
                newimage.SetPixel(i, StartposY + 2, Color.White);
                newimage.SetPixel(i, StartposY + 122, Color.White);
                newimage.SetPixel(i, StartposY + 242, Color.White);
            }
            if ((i - StartposX) % 100 == 0)
            {
                newimage.SetPixel(i, StartposY + 3, Color.White);
                newimage.SetPixel(i, StartposY + 123, Color.White);
                newimage.SetPixel(i, StartposY + 243, Color.White);
            }
        }
        //amoodi
        for (int i = 360; i > EndposY; i--) newimage.SetPixel(StartposX, i, Color.White);
        //for (int i = StartposY; i > EndposY; i--) newimage.SetPixel(StartposX, i, Color.White);
        #endregion

        #region colors
        int startBar = 0, endBar = 0;
        for (int i = StartposX; i < EndposX; i++)
        {
            startBar = StartposY;
            endBar = startBar - Convert.ToInt32(System.Math.Ceiling(rCount[i - StartposX]));
            for (int j = startBar; j >= endBar; j--)
                try { newimage.SetPixel(i, j, Color.FromArgb(50, 0, 0)); }
                catch { break; }

            startBar = StartposY + 120;
            endBar = startBar - Convert.ToInt32(System.Math.Ceiling(gCount[i - StartposX]));
            for (int j = startBar; j >= endBar; j--)
                try { newimage.SetPixel(i, j, Color.FromArgb(0, 50, 0)); }
                catch { break; }

            startBar = StartposY + 240;
            endBar = startBar - Convert.ToInt32(System.Math.Ceiling(bCount[i - StartposX]));
            for (int j = startBar; j >= endBar; j--)
                try { newimage.SetPixel(i, j, Color.FromArgb(0, 0, 50)); }
                catch { break; }
        }
        #endregion
        /*
        #region calc MaxColor
        newimage = IPBL.Editors.past(newimage,
            new Bitmap("max.bmp"),
            "transpb", StartposX - 10 + rmaxIndex, StartposY - Convert.ToInt32(System.Math.Ceiling(rCount[rmaxIndex])) - 10);
        newimage = IPBL.Editors.past(newimage,
            new Bitmap("\\max.bmp"),
            "transpb", StartposX - 10 + gmaxIndex, StartposY + 120 - Convert.ToInt32(System.Math.Ceiling(gCount[gmaxIndex])) - 10);
        newimage = IPBL.Editors.past(newimage,
            new Bitmap("\\max.bmp"),
            "transpb", StartposX - 10 + bmaxIndex, StartposY + 240 - Convert.ToInt32(System.Math.Ceiling(bCount[bmaxIndex])) - 10);
        #endregion
        */
        return newimage;
    }//draw colers count
    /// <summary>
    /// نمودار برای رنگ میانگین خاکستری
    /// </summary>
    /// <returns>/خروجی یه تصویر 256*100 تایی هستش</returns>
    public static Bitmap GrayLevelsHistogram(ref Bitmap image)
    {
        Bitmap Gimage = IPBL.Filters.rgb2gray(ref image, "avg");
        int width = Gimage.Width, height = Gimage.Height;
        int[, ,] Gimagematris = Matris.Load.Matris3DFromeBMP_(ref Gimage);

        #region calc
        int[] GLevelsInt = Matris.Histogram.IntensityGray(ref Gimagematris, width, height);
        int max = 0;
        for (int i = 0; i < 256; i++) if (GLevelsInt[i] > max) max = GLevelsInt[i];
        for (int i = 0; i < 256; i++)
            GLevelsInt[i] = Convert.ToInt32(Convert.ToDouble(GLevelsInt[i] * 100) / max);
        #endregion

        #region Draw Histogram
        Bitmap retImge = new Bitmap(256, 100);

        #region rulers
        //خط عمودی
        for (int i = 0; i < 256; i += 16)
            for (int j = 0; j < 100; j++)
                retImge.SetPixel(i, j, Color.DarkGray);
        //حط عمودی
        for (int j = 0; j < 100; j += 10)
            for (int i = 0; i < 256; i++)
                retImge.SetPixel(i, j, Color.DarkGray);
        #endregion

        #region Hist
        for (int i = 0; i < 256; i++)
        {
            int GInt = 100 - GLevelsInt[i];
            GInt = GInt > 99 ? 99 : GInt < 0 ? 0 : GInt;
            for (int j = 99; j >= GInt; j--) retImge.SetPixel(i, j, Color.LightGray);
        }
        #endregion

        #endregion

        return retImge;
    }

    /// <summary>
    /// مثلا قرار بود هیستوگرام رو کش بده تا از 0 تا 256 پر بشن. البته یه حد هم گذاشته تا مثلا بیشتر کش بده
    /// </summary>
    public static Bitmap StrechHistogram(ref Bitmap image, int thresholdPercentage)
    {
        int[, ,] imagematris = Matris.Load.Matris3DFromeBMP(image);
        int width = image.Width, height = image.Height;
        image.Dispose();


        int[,] hist = Matris.Histogram.colorsCount(ref imagematris, width, height);

        int rmax = 0; for (int i = 0; i < 256; i++) if (hist[0, i] > rmax) rmax = hist[0, i];
        int minThreshr = rmax * thresholdPercentage / 100;//5% is the min threshold
        int firstr = 0; for (int i = 0; i < 256; i++) if (hist[0, i] >= minThreshr) { firstr = i; break; }
        int lastr = 255;
        if (hist[0, 255] >= minThreshr) lastr = 255;
        else for (int i = 255; i >= 0; i--) if (hist[0, i] <= minThreshr) { lastr = i; break; }

        int gmax = 0; for (int i = 0; i < 256; i++) if (hist[1, i] > gmax) gmax = hist[1, i];
        int minThreshg = gmax * thresholdPercentage / 100;//5% is the min threshold
        int firstg = 0; for (int i = 0; i < 256; i++) if (hist[1, i] >= minThreshg) { firstg = i; break; }
        int lastg = 255;
        if (hist[1, 255] >= minThreshg) lastg = 255;
        else for (int i = 255; i >= 0; i--) if (hist[1, i] <= minThreshg) { lastg = i; break; }

        int bmax = 0; for (int i = 0; i < 256; i++) if (hist[2, i] > bmax) bmax = hist[2, i];
        int minThreshb = bmax * thresholdPercentage / 100;//5% is the min threshold
        int firstb = 0; for (int i = 0; i < 256; i++) if (hist[2, i] >= minThreshb) { firstb = i; break; }
        int lastb = 255;
        if (hist[2, 255] >= minThreshb) lastb = 255;
        else for (int i = 255; i >= 0; i--) if (hist[2, i] <= minThreshb) { lastb = i; break; }

        Matris.Histogram.StrechHistogram(ref imagematris, width, height, "r", 0, 255, firstr, lastr);
        Matris.Histogram.StrechHistogram(ref imagematris, width, height, "g", 0, 255, firstg, lastg);
        Matris.Histogram.StrechHistogram(ref imagematris, width, height, "b", 0, 255, firstb, lastb);

        Matris.Math.ApplyThreshold(ref imagematris, width, height, 255, 0);

        return Matris.Load.BMPfromeMatris3D(ref imagematris, width, height);
    }//colors mask

}//class plotter
